---
title: Rewrite page path for visitors in specific countries · Cloudflare Rules docs
description: Create two URL rewrite rules (part of Transform Rules) to rewrite
  the path of the welcome page for visitors in specific countries.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/rewrite-welcome-for-countries/
  md: https://developers.cloudflare.com/rules/transform/examples/rewrite-welcome-for-countries/index.md
---

To have a welcome page in two languages, create two URL rewrite rules with a static rewrite of the path component:

**URL rewrite rule #1**

Text in **Expression Editor**:

```txt
http.request.uri.path == "/welcome.html" && ip.src.country == "GB"
```

Text after **Path** > **Rewrite to** > *Static*:

```txt
/welcome-gb.html
```

**URL rewrite rule #2**

Text in **Expression Editor**:

```txt
http.request.uri.path == "/welcome.html" && ip.src.country == "PT"
```

Text after **Path** > **Rewrite to** > *Static*:

```txt
/welcome-pt.html
```
